<?php
require_once 'db_connection.php';
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
$user_id = $_SESSION['user_id'];

$message = '';
$error = '';

// Handle Ticket Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_ticket'])) {
    $subject = trim($_POST['subject'] ?? '');
    $content = trim($_POST['message'] ?? '');
    $image_url = null;

    if (empty($subject) || empty($content)) {
        $error = "Subject and message cannot be empty.";
    } else {
        if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
            $target_dir = "uploads/support/";
            if (!is_dir($target_dir)) { mkdir($target_dir, 0777, true); }
            $image_name = "support_" . $user_id . "_" . time() . '.' . pathinfo($_FILES["image"]["name"], PATHINFO_EXTENSION);
            $target_file = $target_dir . $image_name;
            $allowed_types = ['image/png', 'image/jpeg', 'image/gif'];
            if(in_array($_FILES['image']['type'], $allowed_types) && move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                $image_url = $target_file;
            } else { $error = "Invalid image file type or failed to upload."; }
        }

        if(empty($error)) {
            $stmt = $conn->prepare("INSERT INTO support_tickets (user_id, subject, message, image_url) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("isss", $user_id, $subject, $content, $image_url);
            if ($stmt->execute()) {
                $message = "Your support ticket has been submitted successfully!";
            } else {
                $error = "Failed to submit your ticket.";
            }
            $stmt->close();
        }
    }
}


// Fetch user's tickets
$tickets = [];
$stmt_tickets = $conn->prepare("SELECT id, subject, message, image_url, status, admin_reply, created_at, updated_at FROM support_tickets WHERE user_id = ? ORDER BY created_at DESC");
$stmt_tickets->bind_param("i", $user_id);
$stmt_tickets->execute();
$result = $stmt_tickets->get_result();
while ($row = $result->fetch_assoc()) {
    $tickets[] = $row;
}
$stmt_tickets->close();
$conn->close();

function getStatusBadge($status) {
    switch ($status) {
        case 'replied': return 'bg-green-100 text-green-800';
        case 'rejected': return 'bg-red-100 text-red-800';
        default: return 'bg-yellow-100 text-yellow-800';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support Center</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                <h1 class="text-3xl font-bold text-gray-800">Support Center</h1>
                <a href="index.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <?php if ($message): ?><div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
            <?php if ($error): ?><div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

            <!-- New Ticket Form -->
            <div class="bg-gray-50 p-6 rounded-lg mb-8 border">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Create a New Ticket</h2>
                <form method="POST" enctype="multipart/form-data" class="space-y-4">
                    <div>
                        <label for="subject" class="block text-sm font-medium text-gray-700">Subject</label>
                        <input type="text" name="subject" id="subject" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="e.g., Payment Issue">
                    </div>
                    <div>
                        <label for="message" class="block text-sm font-medium text-gray-700">Message</label>
                        <textarea name="message" id="message" rows="5" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="Please describe your issue in detail..."></textarea>
                    </div>
                    <div>
                        <label for="image" class="block text-sm font-medium text-gray-700">Attach Image (Optional)</label>
                        <input type="file" name="image" id="image" accept="image/*" class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100"/>
                    </div>
                    <div>
                        <button type="submit" name="submit_ticket" class="w-full bg-indigo-600 text-white font-semibold py-2.5 px-4 rounded-lg hover:bg-indigo-700">Submit Ticket</button>
                    </div>
                </form>
            </div>
            
            <!-- Ticket History -->
            <div>
                 <h2 class="text-xl font-semibold text-gray-700 mb-4">Your Ticket History</h2>
                 <div class="space-y-4">
                     <?php if (empty($tickets)): ?>
                         <p class="text-center text-gray-500 py-10">You have no support tickets.</p>
                     <?php else: foreach ($tickets as $ticket): ?>
                         <div class="border rounded-lg p-4 bg-white">
                             <div class="flex justify-between items-center">
                                 <h3 class="font-bold text-lg text-gray-800"><?php echo htmlspecialchars($ticket['subject']); ?></h3>
                                 <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo getStatusBadge($ticket['status']); ?>"><?php echo ucfirst($ticket['status']); ?></span>
                             </div>
                             <p class="text-gray-600 mt-2"><?php echo nl2br(htmlspecialchars($ticket['message'])); ?></p>
                             <?php if($ticket['image_url']): ?>
                                <a href="<?php echo htmlspecialchars($ticket['image_url']); ?>" target="_blank" class="text-sm text-blue-500 hover:underline mt-2 inline-block">View Attached Image</a>
                             <?php endif; ?>

                             <?php if($ticket['admin_reply']): ?>
                                <div class="mt-4 pt-4 border-t border-gray-200">
                                    <h4 class="font-semibold text-gray-700">Admin's Reply:</h4>
                                    <p class="text-gray-600 bg-gray-100 p-3 rounded-md mt-2"><?php echo nl2br(htmlspecialchars($ticket['admin_reply'])); ?></p>
                                </div>
                             <?php endif; ?>
                             <p class="text-xs text-gray-400 mt-4 text-right">Last updated: <?php echo date("d M, Y H:i", strtotime($ticket['updated_at'])); ?></p>
                         </div>
                     <?php endforeach; endif; ?>
                 </div>
            </div>
        </div>
    </div>
</body>
</html>
