<?php
require_once 'db_connection.php';

// ব্যবহারকারী লগইন করা না থাকলে index.php পেজে পাঠিয়ে দিন
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// সমস্ত নোটিফিকেশন এবং ব্যবহারকারীর জন্য তাদের পঠিত অবস্থা আনুন
$sql = "SELECT n.id, n.title, n.content, n.created_at, (CASE WHEN un.id IS NULL THEN 0 ELSE 1 END) as is_read
        FROM notifications n 
        LEFT JOIN user_notifications un ON n.id = un.notification_id AND un.user_id = ? 
        ORDER BY n.created_at DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$notifications = [];
while ($row = $result->fetch_assoc()) {
    $notifications[] = $row;
}
$stmt->close();
$conn->close();

function timeAgo($dateString) {
    $date = new DateTime($dateString);
    $now = new DateTime();
    $interval = $now->diff($date);
    if ($interval->y > 0) return $interval->y . " years ago";
    if ($interval->m > 0) return $interval->m . " months ago";
    if ($interval->d > 0) return $interval->d . " days ago";
    if ($interval->h > 0) return $interval->h . " hours ago";
    if ($interval->i > 0) return $interval->i . " minutes ago";
    return "Just now";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Notifications</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-8 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">All Notifications</h1>
                 <a href="index.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <div class="space-y-4">
                <?php if (empty($notifications)): ?>
                    <p class="text-center text-gray-500 py-10">You have no notifications yet.</p>
                <?php else: ?>
                    <?php foreach ($notifications as $notif): ?>
                        <div id="notif-<?php echo $notif['id']; ?>" class="p-5 rounded-lg border <?php echo $notif['is_read'] ? 'bg-white' : 'bg-indigo-50 border-indigo-200'; ?>">
                            <div class="flex justify-between items-start">
                                <h2 class="text-lg font-semibold text-gray-800"><?php echo htmlspecialchars($notif['title']); ?></h2>
                                <span class="text-xs text-gray-500 whitespace-nowrap ml-4"><?php echo timeAgo($notif['created_at']); ?></span>
                            </div>
                            <p class="text-gray-600 mt-2">
                                <?php echo nl2br(htmlspecialchars($notif['content'])); ?>
                            </p>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>
