<?php
require_once 'db_connection.php';
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}
$user_id = $_SESSION['user_id'];

// Fetch settings for branding and referral bonus
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($result_settings) {
    while ($row = $result_settings->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$site_name = htmlspecialchars($settings['site_name'] ?? 'DATLAB');
$site_favicon = htmlspecialchars($settings['site_favicon'] ?? '');
$site_url = rtrim(htmlspecialchars($settings['site_url'] ?? ''), '/');
$referrer_bonus = (int)($settings['referrer_bonus'] ?? 50);

// Fetch current user's referral code
$stmt_user = $conn->prepare("SELECT referral_code FROM users WHERE id = ?");
$stmt_user->bind_param("i", $user_id);
$stmt_user->execute();
$user_data = $stmt_user->get_result()->fetch_assoc();
$referral_code = $user_data['referral_code'] ?? '';
$referral_link = $site_url . '/?ref=' . $referral_code;
$stmt_user->close();

// Fetch users referred by the current user
$referred_users = [];
$stmt_referrals = $conn->prepare("SELECT name, created_at FROM users WHERE referred_by = ? ORDER BY created_at DESC");
$stmt_referrals->bind_param("i", $user_id);
$stmt_referrals->execute();
$result_referrals = $stmt_referrals->get_result();
while ($row = $result_referrals->fetch_assoc()) {
    $referred_users[] = $row;
}
$stmt_referrals->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Referrals - <?php echo $site_name; ?></title>
    <?php if ($site_favicon): ?><link rel="icon" href="<?php echo $site_favicon; ?>"><?php endif; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">My Referrals</h1>
                 <a href="index.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <!-- Referral Code Section -->
            <div class="bg-indigo-50 p-6 rounded-lg mb-8 border border-indigo-200">
                <h2 class="text-xl font-semibold text-gray-700">Your Referral Link</h2>
                <p class="text-gray-600 mt-1">Share this link with your friends. When they sign up using your link, you both get bonus tokens!</p>
                <div class="mt-4 flex items-center gap-2">
                    <input type="text" id="referral_link_text" value="<?php echo htmlspecialchars($referral_link); ?>" readonly class="flex-grow p-3 border rounded-lg bg-white font-mono text-lg">
                    <button id="copy-btn" class="bg-indigo-600 text-white font-semibold py-3 px-5 rounded-lg hover:bg-indigo-700">
                        <i class="fas fa-copy mr-2"></i>Copy
                    </button>
                </div>
            </div>

            <!-- Referred Users Table -->
            <div>
                 <h2 class="text-xl font-semibold text-gray-700 mb-4">Users You've Referred</h2>
                 <div class="overflow-x-auto rounded-lg border">
                     <table class="min-w-full divide-y divide-gray-200">
                         <thead class="bg-gray-50">
                             <tr>
                                 <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User Name</th>
                                 <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date Joined</th>
                                 <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Bonus Earned</th>
                             </tr>
                         </thead>
                         <tbody class="bg-white divide-y divide-gray-200">
                             <?php if (empty($referred_users)): ?>
                                 <tr><td colspan="3" class="px-6 py-10 text-center text-gray-500">You haven't referred anyone yet.</td></tr>
                             <?php else: ?>
                                 <?php foreach ($referred_users as $user): ?>
                                     <tr>
                                         <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['name']); ?></td>
                                         <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date("F j, Y", strtotime($user['created_at'])); ?></td>
                                         <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-green-600">+<?php echo number_format($referrer_bonus); ?> Tokens</td>
                                     </tr>
                                 <?php endforeach; ?>
                             <?php endif; ?>
                         </tbody>
                     </table>
                 </div>
            </div>
        </div>
    </div>
    <div id="toast" class="fixed bottom-5 right-5 bg-green-600 text-white py-2 px-4 rounded-lg shadow-lg opacity-0 transition-all duration-300"></div>
    
    <script>
        function showToast(message) {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.classList.remove('opacity-0');
            setTimeout(() => { toast.classList.add('opacity-0'); }, 2000);
        }

        document.getElementById('copy-btn').addEventListener('click', function() {
            const referralText = document.getElementById('referral_link_text');
            referralText.select();
            referralText.setSelectionRange(0, 99999); // For mobile devices
            document.execCommand('copy');
            showToast('Referral link copied to clipboard!');
        });
    </script>
</body>
</html>

