<?php
require_once 'db_connection.php';
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$message = '';
$error = '';

// Fetch settings for site URL
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings");
if ($result_settings) {
    while ($row = $result_settings->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$site_url = rtrim(htmlspecialchars($settings['site_url'] ?? ''), '/');


// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $mobile = trim($_POST['mobile']);
    $address = trim($_POST['address']);
    $country = trim($_POST['country']);
    
    // Handle Profile Picture Upload
    $profile_picture_path = $_POST['current_profile_picture']; // Keep old picture by default
    if (isset($_FILES['profile_picture']) && $_FILES['profile_picture']['error'] == 0) {
        $target_dir = "uploads/profiles/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $image_name = "user_" . $user_id . "_" . time() . '.' . pathinfo($_FILES["profile_picture"]["name"], PATHINFO_EXTENSION);
        $target_file = $target_dir . $image_name;
        
        $allowed_types = ['image/png', 'image/jpeg', 'image/gif'];
        if(in_array($_FILES['profile_picture']['type'], $allowed_types) && move_uploaded_file($_FILES["profile_picture"]["tmp_name"], $target_file)) {
            // Delete old picture if it exists and is not the default
            if ($profile_picture_path && strpos($profile_picture_path, 'placehold.co') === false && file_exists($profile_picture_path)) {
                unlink($profile_picture_path);
            }
            $profile_picture_path = $target_file;
        } else {
            $error = "Invalid file type or failed to upload. Please use JPG, PNG, or GIF.";
        }
    }

    if (empty($error)) {
        $stmt = $conn->prepare("UPDATE users SET name = ?, mobile = ?, address = ?, country = ?, profile_picture = ? WHERE id = ?");
        $stmt->bind_param("sssssi", $name, $mobile, $address, $country, $profile_picture_path, $user_id);

        if ($stmt->execute()) {
            $message = "Profile updated successfully!";
        } else {
            $error = "Failed to update profile.";
        }
        $stmt->close();
    }
}

// Fetch user data for the form
$stmt_user = $conn->prepare("SELECT name, email, mobile, address, country, profile_picture, referral_code FROM users WHERE id = ?");
$stmt_user->bind_param("i", $user_id);
$stmt_user->execute();
$result = $stmt_user->get_result();
$user_data = $result->fetch_assoc();
$referral_link = $site_url . '/index.php?ref=' . ($user_data['referral_code'] ?? '');
$stmt_user->close();

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Profile</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-2xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Edit Profile</h1>
                 <a href="index.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <?php if ($message): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div>
            <?php endif; ?>
             <?php if ($error): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data" class="space-y-6">
                <div class="text-center">
                    <img src="<?php echo htmlspecialchars($user_data['profile_picture'] ?? 'https://placehold.co/128x128/e2e8f0/64748b?text=U'); ?>" alt="Profile Picture" class="w-32 h-32 rounded-full object-cover mx-auto border-4 border-indigo-200">
                    <label for="profile_picture" class="cursor-pointer mt-2 inline-block text-sm text-indigo-600 font-semibold">Change Picture</label>
                    <input type="file" name="profile_picture" id="profile_picture" class="hidden">
                    <input type="hidden" name="current_profile_picture" value="<?php echo htmlspecialchars($user_data['profile_picture']); ?>">
                </div>
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700">Full Name</label>
                    <input type="text" name="name" id="name" value="<?php echo htmlspecialchars($user_data['name']); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email Address (Cannot be changed)</label>
                    <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($user_data['email']); ?>" disabled class="mt-1 block w-full rounded-md border-gray-300 shadow-sm bg-gray-100">
                </div>
                 <div>
                    <label for="mobile" class="block text-sm font-medium text-gray-700">Mobile Number</label>
                    <input type="text" name="mobile" id="mobile" value="<?php echo htmlspecialchars($user_data['mobile'] ?? ''); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                 <div>
                    <label for="address" class="block text-sm font-medium text-gray-700">Address</label>
                    <input type="text" name="address" id="address" value="<?php echo htmlspecialchars($user_data['address'] ?? ''); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label for="country" class="block text-sm font-medium text-gray-700">Country</label>
                    <input type="text" name="country" id="country" value="<?php echo htmlspecialchars($user_data['country'] ?? ''); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                 <div class="bg-gray-50 p-4 rounded-lg">
                    <label for="referral_link" class="block text-sm font-medium text-gray-700">Your Referral Link</label>
                    <input type="text" id="referral_link" value="<?php echo htmlspecialchars($referral_link); ?>" readonly onclick="copyToClipboard(this.value, 'Referral link copied!')" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm bg-gray-200 cursor-pointer" title="Click to copy">
                     <p class="text-xs text-gray-500 mt-1">Share this link with your friends.</p>
                </div>
                <div class="flex justify-end pt-4">
                    <button type="submit" class="w-full bg-indigo-600 text-white font-semibold py-2.5 px-4 rounded-lg hover:bg-indigo-700">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
    <div id="toast" class="fixed bottom-5 right-5 bg-green-600 text-white py-2 px-4 rounded-lg shadow-lg opacity-0 transition-all duration-300"></div>
    <script>
        function showToast(message) {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.classList.remove('opacity-0');
            setTimeout(() => { toast.classList.add('opacity-0'); }, 2000);
        }

        function copyToClipboard(text, message) {
            navigator.clipboard.writeText(text).then(function() {
                showToast(message);
            }, function(err) {
                showToast('Failed to copy!');
            });
        }
    </script>
</body>
</html>

