<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$ticket_id = (int)($_GET['id'] ?? 0);
if ($ticket_id === 0) {
    header("Location: manage_support.php");
    exit();
}

$message = '';
$error = '';

// Handle Reply Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_reply'])) {
    $admin_reply = trim($_POST['admin_reply']);
    if (empty($admin_reply)) {
        $error = "Reply message cannot be empty.";
    } else {
        $stmt = $conn->prepare("UPDATE support_tickets SET admin_reply = ?, status = 'replied' WHERE id = ?");
        $stmt->bind_param("si", $admin_reply, $ticket_id);
        if ($stmt->execute()) {
            $message = "Reply sent successfully!";
        } else {
            $error = "Failed to send reply.";
        }
        $stmt->close();
    }
}

// Fetch ticket details
$sql = "SELECT t.*, u.name as user_name, u.email as user_email 
        FROM support_tickets t 
        JOIN users u ON t.user_id = u.id 
        WHERE t.id = ?";
$stmt_ticket = $conn->prepare($sql);
$stmt_ticket->bind_param("i", $ticket_id);
$stmt_ticket->execute();
$ticket = $stmt_ticket->get_result()->fetch_assoc();
$stmt_ticket->close();

if (!$ticket) {
    header("Location: manage_support.php");
    exit();
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reply to Ticket</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Support Ticket #<?php echo $ticket['id']; ?></h1>
                 <a href="manage_support.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Ticket List</a>
            </div>

            <?php if ($message): ?><div class="bg-green-100 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
            <?php if ($error): ?><div class="bg-red-100 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

            <!-- Ticket Details -->
            <div class="bg-gray-50 p-6 rounded-lg border mb-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    <div><strong>User:</strong> <?php echo htmlspecialchars($ticket['user_name']); ?></div>
                    <div><strong>Email:</strong> <?php echo htmlspecialchars($ticket['user_email']); ?></div>
                    <div><strong>Subject:</strong> <?php echo htmlspecialchars($ticket['subject']); ?></div>
                    <div><strong>Date:</strong> <?php echo date("d M, Y H:i", strtotime($ticket['created_at'])); ?></div>
                </div>
                <div class="mt-4 pt-4 border-t">
                    <p class="font-semibold text-gray-800">User's Message:</p>
                    <p class="text-gray-600 mt-1"><?php echo nl2br(htmlspecialchars($ticket['message'])); ?></p>
                     <?php if($ticket['image_url']): ?>
                        <div class="mt-4">
                             <p class="font-semibold text-gray-800">Attachment:</p>
                             <a href="../<?php echo htmlspecialchars($ticket['image_url']); ?>" target="_blank">
                                <img src="../<?php echo htmlspecialchars($ticket['image_url']); ?>" alt="Attachment" class="mt-2 rounded-lg max-w-xs border">
                            </a>
                        </div>
                     <?php endif; ?>
                </div>
            </div>

            <!-- Reply Form -->
            <div>
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Your Reply</h2>
                <?php if ($ticket['status'] === 'replied' && !empty($ticket['admin_reply'])): ?>
                    <div class="bg-blue-50 p-4 rounded-lg border border-blue-200">
                        <p class="font-semibold">Previous Reply:</p>
                        <p class="text-gray-700 mt-1"><?php echo nl2br(htmlspecialchars($ticket['admin_reply'])); ?></p>
                    </div>
                <?php else: ?>
                    <form method="POST">
                        <textarea name="admin_reply" rows="6" required class="w-full p-3 border rounded-lg" placeholder="Type your reply here..."></textarea>
                        <div class="flex justify-end mt-4">
                            <button type="submit" name="submit_reply" class="bg-indigo-600 text-white font-semibold py-2 px-6 rounded-lg hover:bg-indigo-700">Send Reply</button>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>
