<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$message = '';
$error = '';

// Handle Reject Action
if (isset($_GET['action']) && $_GET['action'] === 'reject' && isset($_GET['id'])) {
    $ticket_id = (int)$_GET['id'];
    $stmt = $conn->prepare("UPDATE support_tickets SET status = 'rejected' WHERE id = ? AND status = 'pending'");
    $stmt->bind_param("i", $ticket_id);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        $message = "Ticket has been rejected.";
    } else {
        $error = "Failed to reject ticket or it was already processed.";
    }
    $stmt->close();
}


// Fetch all tickets with user info
$sql = "SELECT t.*, u.name as user_name, u.email as user_email 
        FROM support_tickets t 
        JOIN users u ON t.user_id = u.id 
        ORDER BY t.created_at DESC";
$all_tickets = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Support Tickets</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; }
        .tab-button.active { border-bottom-color: #4f46e5; color: #4f46e5; font-weight: 600; }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-7xl">
         <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Manage Support Tickets</h1>
                 <a href="admindashboard.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <?php if ($message): ?><div class="bg-green-100 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
            <?php if ($error): ?><div class="bg-red-100 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

            <!-- Tabs Navigation -->
            <div class="border-b border-gray-200 mb-6">
                <nav class="flex space-x-8" aria-label="Tabs">
                    <button class="tab-button active py-4 px-1 text-sm font-medium" data-target="pending">Pending</button>
                    <button class="tab-button py-4 px-1 text-sm font-medium text-gray-500" data-target="replied">Replied</button>
                    <button class="tab-button py-4 px-1 text-sm font-medium text-gray-500" data-target="rejected">Rejected</button>
                </nav>
            </div>

            <!-- Tabs Content -->
            <div id="tab-content">
                <?php foreach (['pending', 'replied', 'rejected'] as $status): ?>
                <div id="<?php echo $status; ?>" class="tab-pane hidden">
                     <div class="overflow-x-auto rounded-lg border">
                         <table class="min-w-full divide-y divide-gray-200">
                             <thead class="bg-gray-50">
                                 <tr>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subject</th>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                     <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Actions</th>
                                 </tr>
                             </thead>
                             <tbody class="bg-white divide-y divide-gray-200">
                                 <?php 
                                    $tickets_for_status = array_filter($all_tickets, fn($t) => $t['status'] === $status);
                                    if (empty($tickets_for_status)): 
                                 ?>
                                     <tr><td colspan="4" class="px-6 py-10 text-center text-gray-500">No <?php echo $status; ?> tickets found.</td></tr>
                                 <?php else: foreach ($tickets_for_status as $ticket): ?>
                                     <tr>
                                         <td class="px-6 py-4">
                                            <div class="font-medium text-gray-900"><?php echo htmlspecialchars($ticket['user_name']); ?></div>
                                            <div class="text-sm text-gray-500"><?php echo htmlspecialchars($ticket['user_email']); ?></div>
                                         </td>
                                         <td class="px-6 py-4 font-medium text-gray-800"><?php echo htmlspecialchars($ticket['subject']); ?></td>
                                         <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date("d M, Y", strtotime($ticket['created_at'])); ?></td>
                                         <td class="px-6 py-4 whitespace-nowrap text-sm text-center space-x-2">
                                            <a href="reply_support.php?id=<?php echo $ticket['id']; ?>" class="text-indigo-600 hover:text-indigo-900">View & Reply</a>
                                            <?php if ($status === 'pending'): ?>
                                                <a href="?action=reject&id=<?php echo $ticket['id']; ?>" onclick="return confirm('Are you sure?');" class="text-red-600 hover:text-red-900">Reject</a>
                                            <?php endif; ?>
                                         </td>
                                     </tr>
                                 <?php endforeach; endif; ?>
                             </tbody>
                         </table>
                     </div>
                </div>
                <?php endforeach; ?>
            </div>
         </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('.tab-button');
            const panes = document.querySelectorAll('.tab-pane');
            document.getElementById('pending').classList.remove('hidden');
            tabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    tabs.forEach(item => item.classList.remove('active'));
                    panes.forEach(pane => pane.classList.add('hidden'));
                    this.classList.add('active');
                    document.getElementById(this.dataset.target).classList.remove('hidden');
                });
            });
        });
    </script>
</body>
</html>
