<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$message = '';
$error = '';

// Handle Delete Post Action
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $post_id_to_delete = (int)$_GET['id'];
    
    $stmt_get = $conn->prepare("SELECT image_url FROM posts WHERE id = ?");
    $stmt_get->bind_param("i", $post_id_to_delete);
    $stmt_get->execute();
    $post_to_delete = $stmt_get->get_result()->fetch_assoc();
    
    if ($post_to_delete) {
        if ($post_to_delete['image_url'] && file_exists('../' . $post_to_delete['image_url'])) {
            unlink('../' . $post_to_delete['image_url']);
        }
        $stmt_delete = $conn->prepare("DELETE FROM posts WHERE id = ?");
        $stmt_delete->bind_param("i", $post_id_to_delete);
        if ($stmt_delete->execute()) {
            $message = "Post deleted successfully!";
        } else {
            $error = "Failed to delete post.";
        }
        $stmt_delete->close();
    }
    $stmt_get->close();
}

// Fetch all posts with user info
$sql = "SELECT p.id, p.content, p.created_at, u.name as user_name, u.email as user_email 
        FROM posts p JOIN users u ON p.user_id = u.id ORDER BY p.created_at DESC";
$all_posts = $conn->query($sql)->fetch_all(MYSQLI_ASSOC);
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage All Posts</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-7xl">
         <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Manage All Posts</h1>
                 <a href="admindashboard.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <?php if ($message): ?><div class="bg-green-100 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
            <?php if ($error): ?><div class="bg-red-100 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

            <div class="overflow-x-auto rounded-lg border">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Author</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Content</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php if (empty($all_posts)): ?>
                            <tr><td colspan="4" class="px-6 py-10 text-center text-gray-500">No posts found.</td></tr>
                        <?php else: foreach ($all_posts as $post): ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="font-medium text-gray-900"><?php echo htmlspecialchars($post['user_name']); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo htmlspecialchars($post['user_email']); ?></div>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-600 max-w-sm truncate"><?php echo htmlspecialchars($post['content']); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date("d M, Y", strtotime($post['created_at'])); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-center space-x-2">
                                    <a href="../edit_post.php?id=<?php echo $post['id']; ?>" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                    <a href="?action=delete&id=<?php echo $post['id']; ?>" onclick="return confirm('Are you sure you want to delete this post?');" class="text-red-600 hover:text-red-900">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; endif; ?>
                    </tbody>
                </table>
            </div>
         </div>
    </div>
</body>
</html>
