<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$message = '';
$error = '';

// Handle Approve/Reject actions
if (isset($_GET['action']) && isset($_GET['id'])) {
    $conn->begin_transaction();
    try {
        $transaction_id = (int)$_GET['id'];
        $action = $_GET['action'];
        $new_status = '';

        if ($action === 'approve') {
            $new_status = 'approved';
        } elseif ($action === 'reject') {
            $new_status = 'rejected';
        }

        if (!empty($new_status)) {
            // Update the transaction status
            $stmt_update = $conn->prepare("UPDATE transactions SET status = ? WHERE id = ? AND status = 'pending'");
            $stmt_update->bind_param("si", $new_status, $transaction_id);
            $stmt_update->execute();

            if ($stmt_update->affected_rows > 0) {
                // If rejected, refund the tokens to the user
                if ($new_status === 'rejected') {
                    $stmt_get_tx = $conn->prepare("SELECT user_id, amount FROM transactions WHERE id = ?");
                    $stmt_get_tx->bind_param("i", $transaction_id);
                    $stmt_get_tx->execute();
                    $tx_result = $stmt_get_tx->get_result();
                    if ($tx = $tx_result->fetch_assoc()) {
                        $stmt_refund = $conn->prepare("UPDATE users SET tokens = tokens + ? WHERE id = ?");
                        $stmt_refund->bind_param("ii", $tx['amount'], $tx['user_id']);
                        $stmt_refund->execute();
                        $stmt_refund->close();
                    }
                    $stmt_get_tx->close();
                }
                $conn->commit();
                $message = "Transaction status updated successfully!";
            } else {
                 $conn->rollback();
                 $error = "Failed to update transaction status. It might have been already processed.";
            }
            $stmt_update->close();
        } else {
            $conn->rollback();
        }
    } catch (Exception $e) {
        $conn->rollback();
        $error = "An error occurred: " . $e->getMessage();
    }
}


// Fetch all transactions
$sql = "SELECT t.id, t.amount, t.payment_method, t.address, t.status, t.created_at, u.name as user_name 
        FROM transactions t 
        JOIN users u ON t.user_id = u.id 
        ORDER BY t.created_at DESC";
$result = $conn->query($sql);

$all_payments = [];
while ($row = $result->fetch_assoc()) {
    $all_payments[] = $row;
}
$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Payments</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; }
        .tab-button {
            transition: all 0.3s;
            border-bottom: 4px solid transparent;
        }
        .tab-button.active {
            border-bottom-color: #4f46e5;
            color: #4f46e5;
            font-weight: 600;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-7xl">
         <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Manage Payment Requests</h1>
                 <a href="admindashboard.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
            </div>

            <?php if ($message): ?>
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div>
            <?php endif; ?>
             <?php if ($error): ?>
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div>
            <?php endif; ?>

            <!-- Tabs Navigation -->
            <div class="border-b border-gray-200 mb-6">
                <nav class="flex space-x-8" aria-label="Tabs">
                    <button class="tab-button active py-4 px-1 text-sm font-medium" data-target="pending">Pending</button>
                    <button class="tab-button py-4 px-1 text-sm font-medium text-gray-500 hover:text-gray-700" data-target="approved">Approved</button>
                    <button class="tab-button py-4 px-1 text-sm font-medium text-gray-500 hover:text-gray-700" data-target="rejected">Rejected</button>
                </nav>
            </div>

            <!-- Tabs Content -->
            <div id="tab-content">
                <?php foreach (['pending', 'approved', 'rejected'] as $status): ?>
                <div id="<?php echo $status; ?>" class="tab-pane hidden">
                     <div class="overflow-x-auto rounded-lg border">
                         <table class="min-w-full divide-y divide-gray-200">
                             <thead class="bg-gray-50">
                                 <tr>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Method & Address</th>
                                     <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                     <?php if ($status === 'pending'): ?>
                                         <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Actions</th>
                                     <?php endif; ?>
                                 </tr>
                             </thead>
                             <tbody class="bg-white divide-y divide-gray-200">
                                 <?php 
                                    $payments_for_status = array_filter($all_payments, fn($p) => $p['status'] === $status);
                                    if (empty($payments_for_status)): 
                                 ?>
                                     <tr><td colspan="<?php echo $status === 'pending' ? '5' : '4'; ?>" class="px-6 py-10 text-center text-gray-500">No <?php echo $status; ?> payments found.</td></tr>
                                 <?php else: ?>
                                     <?php foreach ($payments_for_status as $tx): ?>
                                         <tr>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($tx['user_name']); ?></td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600"><?php echo number_format($tx['amount']); ?> Tokens</td>
                                             <td class="px-6 py-4 text-sm text-gray-600">
                                                <div class="font-medium"><?php echo htmlspecialchars($tx['payment_method']); ?></div>
                                                <div><?php echo htmlspecialchars($tx['address']); ?></div>
                                             </td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date("d M, Y", strtotime($tx['created_at'])); ?></td>
                                             <?php if ($status === 'pending'): ?>
                                                 <td class="px-6 py-4 whitespace-nowrap text-sm text-center space-x-2">
                                                     <a href="manage_payments.php?action=approve&id=<?php echo $tx['id']; ?>" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-full shadow-sm text-white bg-green-600 hover:bg-green-700">Approve</a>
                                                     <a href="manage_payments.php?action=reject&id=<?php echo $tx['id']; ?>" onclick="return confirm('Are you sure you want to reject this and refund the tokens?');" class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded-full shadow-sm text-white bg-red-600 hover:bg-red-700">Reject</a>
                                                 </td>
                                             <?php endif; ?>
                                         </tr>
                                     <?php endforeach; ?>
                                 <?php endif; ?>
                             </tbody>
                         </table>
                     </div>
                </div>
                <?php endforeach; ?>
            </div>
         </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('.tab-button');
            const panes = document.querySelectorAll('.tab-pane');

            // Show pending tab by default
            document.getElementById('pending').classList.remove('hidden');
            
            tabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    tabs.forEach(item => {
                        item.classList.remove('active');
                        item.classList.add('text-gray-500', 'hover:text-gray-700');
                    });
                    panes.forEach(pane => pane.classList.add('hidden'));

                    this.classList.add('active');
                    this.classList.remove('text-gray-500', 'hover:text-gray-700');
                    const targetPane = document.getElementById(this.dataset.target);
                    if (targetPane) {
                        targetPane.classList.remove('hidden');
                    }
                });
            });
        });
    </script>
</body>
</html>
