<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$message = '';
$error = '';

// Handle Send Notification
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send_notification'])) {
    $notification_title = trim($_POST['notification_title'] ?? '');
    $notification_content = trim($_POST['notification_content'] ?? '');
    $notification_link = trim($_POST['notification_link'] ?? null);
    $image_url = null;

    if (isset($_FILES['notification_image']) && $_FILES['notification_image']['error'] == 0) {
        $target_dir = "../uploads/notifications/";
        if (!is_dir($target_dir)) { mkdir($target_dir, 0777, true); }
        $image_name = "notif_" . time() . '.' . pathinfo($_FILES["notification_image"]["name"], PATHINFO_EXTENSION);
        $target_file = $target_dir . $image_name;
        $allowed_types = ['image/png', 'image/jpeg', 'image/gif'];
        if(in_array($_FILES['notification_image']['type'], $allowed_types) && move_uploaded_file($_FILES["notification_image"]["tmp_name"], $target_file)) {
            $image_url = "uploads/notifications/" . $image_name;
        } else { $error = "Invalid image file type or failed to upload."; }
    }


    if (empty($notification_title) || empty($notification_content)) {
        $error = "Notification title and content cannot be empty.";
    } elseif(empty($error)) {
        $stmt = $conn->prepare("INSERT INTO notifications (title, content, image_url, link_url) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $notification_title, $notification_content, $image_url, $notification_link);
        if ($stmt->execute()) {
            $message = "Notification sent successfully to all users!";
        } else {
            $error = "Failed to send notification.";
        }
        $stmt->close();
    }
}


// Handle Delete Action
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $notif_id_to_delete = (int)$_GET['id'];
    
    $stmt_get = $conn->prepare("SELECT image_url FROM notifications WHERE id = ?");
    $stmt_get->bind_param("i", $notif_id_to_delete);
    $stmt_get->execute();
    $notif_to_delete = $stmt_get->get_result()->fetch_assoc();
    
    if ($notif_to_delete) {
        if ($notif_to_delete['image_url'] && file_exists('../' . $notif_to_delete['image_url'])) {
            unlink('../' . $notif_to_delete['image_url']);
        }
        $stmt_delete = $conn->prepare("DELETE FROM notifications WHERE id = ?");
        $stmt_delete->bind_param("i", $notif_id_to_delete);
        if ($stmt_delete->execute()) {
            $message = "Notification deleted successfully!";
        } else {
            $error = "Failed to delete notification.";
        }
        $stmt_delete->close();
    }
    $stmt_get->close();
}

// Fetch all notifications
$all_notifications = $conn->query("SELECT * FROM notifications ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Notifications</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-7xl">
         <div class="bg-white rounded-2xl shadow-xl p-8 space-y-10">
            <div>
                <div class="flex justify-between items-center mb-6 border-b pb-4">
                     <h1 class="text-3xl font-bold text-gray-800">Manage Notifications</h1>
                     <a href="admindashboard.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to Dashboard</a>
                </div>

                <?php if ($message): ?><div class="bg-green-100 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
                <?php if ($error): ?><div class="bg-red-100 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

                 <!-- Send Notification Form -->
                <div class="bg-gray-50 p-6 rounded-lg border">
                    <h2 class="text-xl font-semibold text-gray-700 mb-4">Send New Notification</h2>
                    <form method="POST" enctype="multipart/form-data" class="space-y-4">
                        <div>
                            <label for="notification_title" class="block text-sm font-medium text-gray-700">Title</label>
                            <input type="text" id="notification_title" name="notification_title" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                        </div>
                        <div>
                            <label for="notification_content" class="block text-sm font-medium text-gray-700">Message</label>
                            <textarea id="notification_content" name="notification_content" rows="4" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></textarea>
                        </div>
                        <div>
                            <label for="notification_image" class="block text-sm font-medium text-gray-700">Image (Optional)</label>
                            <input type="file" id="notification_image" name="notification_image" class="mt-1 block w-full text-sm">
                        </div>
                         <div>
                            <label for="notification_link" class="block text-sm font-medium text-gray-700">Link URL (Optional)</label>
                            <input type="url" id="notification_link" name="notification_link" placeholder="https://example.com" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                        </div>
                        <div>
                            <button type="submit" name="send_notification" class="w-full py-2 px-4 text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">Send to All Users</button>
                        </div>
                    </form>
                </div>
            </div>

            <div>
                 <h2 class="text-2xl font-semibold text-gray-700 mb-4">Sent Notifications</h2>
                <div class="overflow-x-auto rounded-lg border">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Title</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Content</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php if (empty($all_notifications)): ?>
                                <tr><td colspan="4" class="px-6 py-10 text-center text-gray-500">No notifications found.</td></tr>
                            <?php else: foreach ($all_notifications as $notif): ?>
                                <tr>
                                    <td class="px-6 py-4 font-medium text-gray-900"><?php echo htmlspecialchars($notif['title']); ?></td>
                                    <td class="px-6 py-4 text-sm text-gray-600 max-w-md truncate"><?php echo htmlspecialchars($notif['content']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo date("d M, Y", strtotime($notif['created_at'])); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-center space-x-4">
                                        <a href="edit_notification.php?id=<?php echo $notif['id']; ?>" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                        <a href="?action=delete&id=<?php echo $notif['id']; ?>" onclick="return confirm('Are you sure?');" class="text-red-600 hover:text-red-900">Delete</a>
                                    </td>
                                </tr>
                            <?php endforeach; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
         </div>
    </div>
</body>
</html>

