<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$notif_id = (int)($_GET['id'] ?? 0);
if ($notif_id === 0) {
    header("Location: manage_notifications.php");
    exit();
}

$message = '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title']);
    $content = trim($_POST['content']);
    $link_url = trim($_POST['link_url']) ?: null;
    $current_image_url = $_POST['current_image_url'];
    
    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        if ($current_image_url && file_exists('../' . $current_image_url)) {
            unlink('../' . $current_image_url);
        }
        $target_dir = "../uploads/notifications/";
        $image_name = "notif_" . time() . '.' . basename($_FILES["image"]["name"]);
        $target_file = $target_dir . $image_name;
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $current_image_url = "uploads/notifications/" . $image_name;
        } else {
            $error = "Failed to upload new image.";
        }
    }

    if (empty($error)) {
        $stmt_update = $conn->prepare("UPDATE notifications SET title = ?, content = ?, image_url = ?, link_url = ? WHERE id = ?");
        $stmt_update->bind_param("ssssi", $title, $content, $current_image_url, $link_url, $notif_id);
        if ($stmt_update->execute()) {
            $message = "Notification updated successfully!";
        } else {
            $error = "Failed to update notification.";
        }
        $stmt_update->close();
    }
}

// Fetch notification data
$stmt = $conn->prepare("SELECT * FROM notifications WHERE id = ?");
$stmt->bind_param("i", $notif_id);
$stmt->execute();
$notification = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$notification) {
    header("Location: manage_notifications.php");
    exit();
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Notification</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style> body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; } </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-2xl">
        <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-6 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Edit Notification</h1>
                 <a href="manage_notifications.php" class="text-indigo-600 hover:text-indigo-800 font-semibold">← Back to List</a>
            </div>
            
            <?php if ($message): ?><div class="bg-green-100 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div><?php endif; ?>
            <?php if ($error): ?><div class="bg-red-100 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div><?php endif; ?>

            <form method="POST" enctype="multipart/form-data" class="space-y-6">
                <input type="hidden" name="current_image_url" value="<?php echo htmlspecialchars($notification['image_url']); ?>">
                <div>
                    <label for="title" class="block text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" id="title" value="<?php echo htmlspecialchars($notification['title']); ?>" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label for="content" class="block text-sm font-medium text-gray-700">Message</label>
                    <textarea name="content" id="content" rows="6" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"><?php echo htmlspecialchars($notification['content']); ?></textarea>
                </div>
                 <div>
                    <label for="link_url" class="block text-sm font-medium text-gray-700">Link URL (Optional)</label>
                    <input type="url" name="link_url" id="link_url" value="<?php echo htmlspecialchars($notification['link_url']); ?>" placeholder="https://example.com" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label for="image" class="block text-sm font-medium text-gray-700">Change Image (Optional)</label>
                    <?php if ($notification['image_url']): ?>
                        <img src="../<?php echo htmlspecialchars($notification['image_url']); ?>" class="my-2 rounded-lg max-h-40">
                    <?php endif; ?>
                    <input type="file" name="image" id="image" accept="image/*" class="mt-1 block w-full text-sm">
                </div>
                <div class="flex justify-end">
                    <button type="submit" class="w-full bg-indigo-600 text-white font-semibold py-2.5 px-6 rounded-lg hover:bg-indigo-700">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
