<?php
require_once '../db_connection.php';
if (!isset($_SESSION['user_id']) || !isset($_SESSION['is_admin']) || !$_SESSION['is_admin']) {
    header("Location: index.php");
    exit();
}

$message = '';
$error = '';

// Handle Settings Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_settings'])) {
    // Handle Logo Upload
    if (isset($_FILES['site_logo']) && $_FILES['site_logo']['error'] == 0) {
        $target_dir = "../uploads/branding/";
        if (!is_dir($target_dir)) { mkdir($target_dir, 0777, true); }
        $logo_name = "logo_" . time() . '.' . pathinfo($_FILES["site_logo"]["name"], PATHINFO_EXTENSION);
        $target_file = $target_dir . $logo_name;
        $allowed_types = ['image/png', 'image/jpeg', 'image/gif', 'image/svg+xml'];
        if(in_array($_FILES['site_logo']['type'], $allowed_types) && move_uploaded_file($_FILES["site_logo"]["tmp_name"], $target_file)) {
            $logo_path = "uploads/branding/" . $logo_name;
            $stmt_logo = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('site_logo', ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt_logo->bind_param("ss", $logo_path, $logo_path);
            $stmt_logo->execute();
        } else { $error = "Invalid logo file type or failed to upload."; }
    }

    // Handle Favicon Upload
    if (isset($_FILES['site_favicon']) && $_FILES['site_favicon']['error'] == 0) {
        $target_dir = "../uploads/branding/";
        if (!is_dir($target_dir)) { mkdir($target_dir, 0777, true); }
        $favicon_name = "favicon_" . time() . '.' . pathinfo($_FILES["site_favicon"]["name"], PATHINFO_EXTENSION);
        $target_file = $target_dir . $favicon_name;
        $allowed_types = ['image/x-icon', 'image/png', 'image/vnd.microsoft.icon'];
         if(in_array($_FILES['site_favicon']['type'], $allowed_types) && move_uploaded_file($_FILES["site_favicon"]["tmp_name"], $target_file)) {
            $favicon_path = "uploads/branding/" . $favicon_name;
            $stmt_favicon = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('site_favicon', ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt_favicon->bind_param("ss", $favicon_path, $favicon_path);
            $stmt_favicon->execute();
        } else { $error = "Invalid favicon file type or failed to upload. Use .ico or .png."; }
    }

    // Handle Text-based Settings
    $site_name = trim($_POST['site_name']);
    $header_title = trim($_POST['header_title']);
    $site_url = trim($_POST['site_url']);
    $post_token_reward = (int)($_POST['post_token_reward'] ?? 5);
    $comment_token_reward = (int)($_POST['comment_token_reward'] ?? 2);
    $daily_post_limit = (int)($_POST['daily_post_limit'] ?? 5);
    $daily_comment_limit = (int)($_POST['daily_comment_limit'] ?? 20);
    $min_withdrawal_amount = (int)($_POST['min_withdrawal_amount'] ?? 1000);
    $claim_now_reward = (int)($_POST['claim_now_reward'] ?? 50);
    $new_user_referral_bonus = (int)($_POST['new_user_referral_bonus'] ?? 100);
    $referrer_bonus = (int)($_POST['referrer_bonus'] ?? 50);
    $posts_per_ad = (int)($_POST['posts_per_ad'] ?? 3);
    $ad_code_header = $_POST['ad_code_header'] ?? '';
    $ad_code_body = $_POST['ad_code_body'] ?? '';
    $ad_code_footer = $_POST['ad_code_footer'] ?? '';
    
    $all_settings = [
        'site_name' => $site_name,
        'header_title' => $header_title,
        'site_url' => $site_url,
        'post_token_reward' => $post_token_reward,
        'comment_token_reward' => $comment_token_reward,
        'daily_post_limit' => $daily_post_limit,
        'daily_comment_limit' => $daily_comment_limit,
        'min_withdrawal_amount' => $min_withdrawal_amount,
        'claim_now_reward' => $claim_now_reward,
        'new_user_referral_bonus' => $new_user_referral_bonus,
        'referrer_bonus' => $referrer_bonus,
        'posts_per_ad' => $posts_per_ad,
        'ad_code_header' => $ad_code_header,
        'ad_code_body' => $ad_code_body,
        'ad_code_footer' => $ad_code_footer,
        'show_profile' => isset($_POST['show_profile']) ? '1' : '0',
        'show_my_referrals' => isset($_POST['show_my_referrals']) ? '1' : '0',
        'show_buy_package' => isset($_POST['show_buy_package']) ? '1' : '0',
        'show_notifications' => isset($_POST['show_notifications']) ? '1' : '0',
        'show_payment' => isset($_POST['show_payment']) ? '1' : '0',
        'show_payment_proofs' => isset($_POST['show_payment_proofs']) ? '1' : '0',
        'show_support' => isset($_POST['show_support']) ? '1' : '0'
    ];

    $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
    foreach ($all_settings as $key => $value) {
        $stmt->bind_param("ss", $key, $value);
        $stmt->execute();
    }
    
    $stmt->close();
    if (empty($error)) {
        $message = "Settings saved successfully!";
    }
}

// সেটিংস ডেটাবেস থেকে লোড করুন
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings");
while ($row = $result_settings->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$conn->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #f0f2f5; }
        .switch { position: relative; display: inline-block; width: 60px; height: 34px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .4s; }
        .slider:before { position: absolute; content: ""; height: 26px; width: 26px; left: 4px; bottom: 4px; background-color: white; transition: .4s; }
        input:checked + .slider { background-color: #4f46e5; }
        input:checked + .slider:before { transform: translateX(26px); }
        .slider.round { border-radius: 34px; }
        .slider.round:before { border-radius: 50%; }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 md:p-8 max-w-7xl">
         <div class="bg-white rounded-2xl shadow-xl p-8">
            <div class="flex justify-between items-center mb-8 border-b pb-4">
                 <h1 class="text-3xl font-bold text-gray-800">Admin Control Panel</h1>
                 <a href="../index.php" class="text-indigo-600 hover:text-indigo-800 font-semibold" target="_blank"><i class="fas fa-external-link-alt mr-2"></i>View Site</a>
            </div>

            <?php if ($message): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $message; ?></p></div>
            <?php endif; ?>
            <?php if ($error): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-md" role="alert"><p><?php echo $error; ?></p></div>
            <?php endif; ?>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <div class="lg:col-span-2">
                    <form method="POST" enctype="multipart/form-data">
                        <!-- Branding Settings -->
                        <div class="mb-8">
                            <h2 class="text-2xl font-semibold text-gray-700 mb-4 pb-2 border-b">Branding Settings</h2>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="site_name" class="block text-sm font-medium text-gray-700 mb-1">Website Name</label>
                                    <input type="text" id="site_name" name="site_name" value="<?php echo htmlspecialchars($settings['site_name'] ?? 'DATLAB'); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                </div>
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="header_title" class="block text-sm font-medium text-gray-700 mb-1">Header Title</label>
                                    <input type="text" id="header_title" name="header_title" value="<?php echo htmlspecialchars($settings['header_title'] ?? 'Feed'); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                </div>
                                 <div class="bg-gray-50 p-4 rounded-lg md:col-span-2">
                                    <label for="site_url" class="block text-sm font-medium text-gray-700 mb-1">Website URL</label>
                                    <input type="url" id="site_url" name="site_url" value="<?php echo htmlspecialchars($settings['site_url'] ?? ''); ?>" placeholder="https://yourdomain.com" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                    <p class="text-xs text-gray-500 mt-1">Used for generating referral links. No slash at the end.</p>
                                </div>
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="site_logo" class="block text-sm font-medium text-gray-700 mb-1">Website Logo</label>
                                    <input type="file" id="site_logo" name="site_logo" class="mt-1 block w-full text-sm">
                                    <?php if(!empty($settings['site_logo'])): ?><img src="../<?php echo htmlspecialchars($settings['site_logo']); ?>" class="h-8 mt-2"><?php endif; ?>
                                </div>
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="site_favicon" class="block text-sm font-medium text-gray-700 mb-1">Website Favicon (.ico, .png)</label>
                                    <input type="file" id="site_favicon" name="site_favicon" class="mt-1 block w-full text-sm">
                                    <?php if(!empty($settings['site_favicon'])): ?><img src="../<?php echo htmlspecialchars($settings['site_favicon']); ?>" class="h-8 mt-2"><?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- General Settings -->
                        <div class="mb-8">
                            <h2 class="text-2xl font-semibold text-gray-700 mb-4 pb-2 border-b">General Settings</h2>
                             <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="claim_now_reward" class="block text-sm font-medium text-gray-700 mb-1">Daily Claim Reward</label><input type="number" id="claim_now_reward" name="claim_now_reward" value="<?php echo htmlspecialchars($settings['claim_now_reward'] ?? 50); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="min_withdrawal_amount" class="block text-sm font-medium text-gray-700 mb-1">Minimum Withdrawal</label><input type="number" id="min_withdrawal_amount" name="min_withdrawal_amount" value="<?php echo htmlspecialchars($settings['min_withdrawal_amount'] ?? 1000); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="new_user_referral_bonus" class="block text-sm font-medium text-gray-700 mb-1">New User Referral Bonus</label><input type="number" id="new_user_referral_bonus" name="new_user_referral_bonus" value="<?php echo htmlspecialchars($settings['new_user_referral_bonus'] ?? 100); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="referrer_bonus" class="block text-sm font-medium text-gray-700 mb-1">Referrer Bonus</label><input type="number" id="referrer_bonus" name="referrer_bonus" value="<?php echo htmlspecialchars($settings['referrer_bonus'] ?? 50); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="post_token_reward" class="block text-sm font-medium text-gray-700 mb-1">Post Reward (Free User)</label><input type="number" id="post_token_reward" name="post_token_reward" value="<?php echo htmlspecialchars($settings['post_token_reward'] ?? 5); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="comment_token_reward" class="block text-sm font-medium text-gray-700 mb-1">Comment Reward (Free User)</label><input type="number" id="comment_token_reward" name="comment_token_reward" value="<?php echo htmlspecialchars($settings['comment_token_reward'] ?? 2); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="daily_post_limit" class="block text-sm font-medium text-gray-700 mb-1">Post Limit (Free User)</label><input type="number" id="daily_post_limit" name="daily_post_limit" value="<?php echo htmlspecialchars($settings['daily_post_limit'] ?? 5); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                                <div class="bg-gray-50 p-4 rounded-lg"><label for="daily_comment_limit" class="block text-sm font-medium text-gray-700 mb-1">Comment Limit (Free User)</label><input type="number" id="daily_comment_limit" name="daily_comment_limit" value="<?php echo htmlspecialchars($settings['daily_comment_limit'] ?? 20); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm"></div>
                            </div>
                        </div>

                        <!-- Advertisement Settings -->
                        <div class="mb-8">
                            <h2 class="text-2xl font-semibold text-gray-700 mb-4 pb-2 border-b">Advertisement Settings</h2>
                            <div class="space-y-4">
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="posts_per_ad" class="block text-sm font-medium text-gray-700 mb-1">Show Ad After How Many Posts</label>
                                    <input type="number" id="posts_per_ad" name="posts_per_ad" value="<?php echo htmlspecialchars($settings['posts_per_ad'] ?? 3); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                                </div>
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="ad_code_header" class="block text-sm font-medium text-gray-700 mb-1">Ad Code (Header)</label>
                                    <textarea id="ad_code_header" name="ad_code_header" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="Paste ad code for <head> section here..."><?php echo htmlspecialchars($settings['ad_code_header'] ?? ''); ?></textarea>
                                </div>
                                <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="ad_code_body" class="block text-sm font-medium text-gray-700 mb-1">Ad Code (In-Feed Body)</label>
                                    <textarea id="ad_code_body" name="ad_code_body" rows="6" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="Paste HTML/JS for the ad block that appears between posts..."><?php echo htmlspecialchars($settings['ad_code_body'] ?? ''); ?></textarea>
                                </div>
                                 <div class="bg-gray-50 p-4 rounded-lg">
                                    <label for="ad_code_footer" class="block text-sm font-medium text-gray-700 mb-1">Ad Code (Footer)</label>
                                    <textarea id="ad_code_footer" name="ad_code_footer" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" placeholder="Paste ad code for the end of the <body> section here..."><?php echo htmlspecialchars($settings['ad_code_footer'] ?? ''); ?></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Menu Visibility Settings -->
                        <div>
                            <h2 class="text-2xl font-semibold text-gray-700 mb-4 pb-2 border-b">Sidebar Menu Visibility</h2>
                            <div class="space-y-4">
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Profile Menu</span><label class="switch"><input type="checkbox" name="show_profile" <?php echo ($settings['show_profile'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">My Referrals Menu</span><label class="switch"><input type="checkbox" name="show_my_referrals" <?php echo ($settings['show_my_referrals'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Buy Package Menu</span><label class="switch"><input type="checkbox" name="show_buy_package" <?php echo ($settings['show_buy_package'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Notifications Menu</span><label class="switch"><input type="checkbox" name="show_notifications" <?php echo ($settings['show_notifications'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Payment Menu</span><label class="switch"><input type="checkbox" name="show_payment" <?php echo ($settings['show_payment'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Payment Proofs Menu</span><label class="switch"><input type="checkbox" name="show_payment_proofs" <?php echo ($settings['show_payment_proofs'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg"><span class="font-medium text-gray-900">Support Menu</span><label class="switch"><input type="checkbox" name="show_support" <?php echo ($settings['show_support'] ?? '1') == '1' ? 'checked' : ''; ?>><span class="slider round"></span></label></div>
                            </div>
                        </div>

                        <div class="mt-8 pt-5 border-t"><div class="flex justify-end"><button type="submit" name="save_settings" class="inline-flex justify-center py-2 px-6 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">Save Settings</button></div></div>
                    </form>
                </div>

                <!-- Right Column for Management Links -->
                <div class="lg:col-span-1 space-y-8">
                     <div>
                         <h2 class="text-2xl font-semibold text-gray-700 mb-4 pb-2 border-b">Management</h2>
                         <div class="space-y-4">
                            <a href="manage_users.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-purple-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-users-cog text-xl text-purple-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Users</h3><p class="text-sm text-gray-500">View, edit, and manage user accounts.</p></div></div></a>
                            <a href="manage_posts.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-yellow-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-copy text-xl text-yellow-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Posts</h3><p class="text-sm text-gray-500">View, edit, and delete user posts.</p></div></div></a>
                            <a href="manage_payments.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-blue-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-tasks text-xl text-blue-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Payments</h3><p class="text-sm text-gray-500">Process user withdrawal requests.</p></div></div></a>
                            <a href="manage_packages.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-green-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-box-open text-xl text-green-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Packages</h3><p class="text-sm text-gray-500">Create, edit, and manage user packages.</p></div></div></a>
                            <a href="manage_notifications.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-red-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-bullhorn text-xl text-red-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Notifications</h3><p class="text-sm text-gray-500">Send, edit, or delete site-wide notifications.</p></div></div></a>
                            <a href="manage_support.php" class="block bg-gray-50 p-4 rounded-lg hover:bg-gray-100"><div class="flex items-center space-x-4"><div class="bg-cyan-100 p-3 rounded-full flex-shrink-0"><i class="fas fa-life-ring text-xl text-cyan-600"></i></div><div><h3 class="font-semibold text-gray-900">Manage Support Tickets</h3><p class="text-sm text-gray-500">View and reply to user queries.</p></div></div></a>
                         </div>
                    </div>
                </div>
            </div>
         </div>
    </div>
</body>
</html>

